//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Importing and cleaning ASNA household finance and wealth balance sheet data
// Objective: 	Read in ASNA household balance sheet data and convert the 
//				figures to December 2019 prices using ABS CPI data.				
//
// Created: 	05/03/2021
// Modified: 	15/11/2021
//==============================================================================

clear all

*****************************************
*** ASNA household balance sheet data ***
*****************************************

import excel "ASNA_household_balance_sheet_finance_wealth.xls", sheet("STATA Import") firstrow case(lower)

rename totalassets					asna_total_assets 			// renaming total assets
rename nonfinancialassets			asna_nf_assets 				// renaming non-financial assets
rename nonfinancialproducedassets	asna_nf_pa 					// renaming non-financial produced assets
rename nonfinancialproducedfixed	asna_nf_pfa 				// renaming non-financial produced fixed assets
rename f							asna_nf_pfa_d 				// renaming non-financial produced fixed assets - dwellings
rename g							asna_nf_pfa_otc 			// renaming non-financial produced fixed assets - ownership transfer costs
rename h							asna_nf_pfa_ndc 			// renaming non-financial produced fixed assets - non-dwelling construction
rename i							asna_nf_pfa_mae 			// renaming non-financial produced fixed assets - machinery and equipment
rename j							asna_nf_pfa_cbr 			// renaming non-financial produced fixed assets - cultivated biological resources
rename k							asna_nf_pfa_ipp 			// renaming non-financial produced fixed assets - intellectual property products
rename l							asna_nf_pa_i 				// renaming non-financial produced assets - inventories
rename m							asna_nf_pa_i_pnf 			// renaming non-financial produced assets - inventories - private non-farm
rename n							asna_nf_pa_i_f				// renaming non-financial produced assets - inventories - farm
rename o							asna_nf_pa_i_pst 			// renaming non-financial produced assets - inventories - plantation standing timber
rename nonfinancialnonproducedass	asna_nf_npa 				// renaming non-financial non-produced assets
rename q							asna_nf_npa_nr_l 			// renaming non-financial non-produced assets - natural resources - land
rename r							asna_nf_npa_nr_nst 			// renaming non-financial non-produced assets - natural resources - native standing timber
rename financialassets				asna_f_assets 				// renaming financial assets
rename financialassetscurrencyand	asna_fa_cad 				// renaming financial assets - currency and deposits
rename financialassetssecuritiesot	asna_fa_sots 				// renaming financial assets - securities other than shares
rename financialassetsloansandpla	asna_fa_lap 				// renaming financial assets - loans and placements
rename financialassetssharesandot	asna_fa_saoe 				// renaming financial assets - shares and other equity
rename financialassetsinsurancetec	asna_fa_itrs 				// renaming financial assets - insurance technical reserves - superannuation
rename y							asna_fa_itro				// renaming financial assets - insurance technical reserves - other
rename financialassetsotheraccount	asna_fa_oar 				// renaming financial assets - other accounts receivable
rename liabilitiesincludingsharecap	asna_liabilities 			// renaming liabilities (including share capital)
rename liabilitiessecuritiesothert	asna_l_sots 				// renaming liabilities - securities other than shares
rename liabilitiesloansandplacemen	asna_l_lap 					// renaming liabilities - loans and placements
rename liabilitiesotheraccountspay	asna_l_oap 					// renaming liabilities - other accounts payable
rename networth						asna_net_worth 				// renaming net worth
rename residentiallandanddwellings	asna_res_land_dwel			// renaming residential land and dwellings
rename consumerdurables				asna_consumer_durables 		// renaming consumer durables


gen year = year(date)
gen month = month(date)

save "ASNA Quarterly Wealth Current", replace